*************************************************
*** This do-file creates figure 3, 4, 8 and 9 ***
*************************************************

clear
clear matrix
set matsize 4000
set mem 4g

* !!! PLEASE SPECIFY !!! the directory where the file nj_respondents_new.dta is stored:
local njdir=""

* !!! PLEASE SPECIFY !!!

* for figure 3, please type:
* local variablesx "tu_jobsearch tw_jobsearch"

* for figure 4, please type:
* local variablesx "tup_jobsearch tum_jobsearch"

* for figure 8, please type:
* local variablesx "mood_1"

* for figure 9, pleasy type:
* local variablesx "sel_sad"

* for figures 3, 4, 8 and 9, please type:
local variablesx "tw_jobsearch tw_jobsearch tup_jobsearch tum_jobsearch mood_1 sel_sad"

foreach varx of local variablesx {

* !!! PLEASE SPECIFY !!! if you dont want to produce the figures for fixed effects, cohort effects and residuals
local ifix=1
local icoh=0
local ires=0
local ituforce=0

* !!! PLEASE SPECIFY !!! if you want weighted or unweighted estimates (iwgt=1 --> weighted, iwgt=0 --> unweighted)
local iwgt=1

* !!! PLEASE SPECIFY !!! if you want to drop the last 2 weeks of November and December (if ixmas=1, then drop; 0 otherwise)
local ixmas=0

* !!! PLEASE SPECIFY !!! if you want to show average for cohorts or not (averages indid==1; 0 otherwise)
local indid=1

*** variables over which looped
*** - reservation wage ratio: "rwr"
*** - time spent on job search: "tu_jobsearch"
*** - time spent on job search (participation): "tup_jobsearch"
*** - time spent on job search (conditional on participation): "tum_jobsearch"
*** - time spent on job search (counting every episode as 1 hour): "ta_jobsearch"
*** - time spent on job search (weekly): "tw_jobsearch"
*** - time spent on job search (weekly, participation): "twp_jobsearch"
*** - time spent on job search (weekly, conditional on participation): "twm_jobsearch"
*** - number of applications: "nappl"
*** - food consumption: "foodtot"
*** - sold durable: "durab"
*** - industries: "ind_*"
*** - mood, emotions and life satisfaction

* load raw file
use `njdir'nj_respondents_new.dta, clear

* cells with less than x observations are dropped from graphs
local ndrop = 50

* name graphs and titles
local titlab2=""
local txtnote="Notes: "
local txtndrop="Cells with less than `ndrop' observations are dropped from the graph."

* special sample restriction
if `ixmas'==1 {
drop if fmonth==11 & fday>15
drop if fmonth==12 & fday>15
local ngraph = "_noxmas"
local ndrop = 30
local subtitlab="(without last two weeks of November and December)"
}

local txtsvywgt = "Survey weights are used. "
if `iwgt'==0 {
replace curwkwgt=1
local ngraph = "_nowgt"
local txtsvywgt = "Estimates are not weighted with survey weights."
local titlab2 = "(unweighted)"
}

* average or not for industry graphs
local indi=0
if `indid'==0 {
local ngraph = "_noavg"
}


* drop cases who have accepted job or are working in survey week and age <20 and age>65
keep if insample_wrkacc==1
gen ud = round(udur_wkpd_wrkacc)
drop if age < 20
drop if age > 65

* duration dummies
quietly tab ud, gen(ud_dummy_)

* day of the week dummies
quietly tab q2, gen(q2_)
drop q2_1

* predicted value at start of spell:
local ipred = 0
if `ipred'==1 {
reg tu_jobsearch age agesq school lprevwage_wkly lbenerate female r_* ethnic_* ind_* dateclaim udur_wkpd_wrkacc q2_* [pw=curwkwgt] if coh==1 & curwkwgt_tu!=.
predict tupred
gen tupred0 = tupred - udur_wkpd_wrkacc*_b[udur_wkpd_wrkacc] if curwkwgt_tu!=.
reg tu_jobsearch age agesq school lprevwage_wkly lbenerate female r_* ethnic_* ind_* dateclaim udur_wkpd_wrkacc [pw=curwkwgt] if coh==1 & curwkwgt_tu!=.
predict twpred
gen twpred0 = twpred - udur_wkpd_wrkacc*_b[udur_wkpd_wrkacc]
tabstat tupred0 twpred0 [aw=perswgt] if week==1 , by(coh) stats(mean)
stop
}


* inputs depending on the variable chosen above (variable, weights used, range on graph, ticks on graph)
if "`varx'"=="rwr" {
gen   vart = rwr
gen   varwgt = curwkwgt
local titlab = "Reservation wage ratio `titlab2'"
local ylab=""
* range
local varx_m=0.85
local varx_p=1.15
*ticks
local varx_d=0.1
*time use statistic
local itu=0
}

if "`varx'"=="tu_jobsearch" {
gen   vart = tu_jobsearch
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Time spent on job search (yesterday) `titlab2'"
local ylab = "Minutes per day"
* range
local varx_m=0
local varx_p=160
*ticks
local varx_d=40
local itu=1
}


if "`varx'"=="tup_jobsearch" {
gen   vart = (tu_jobsearch>0) if tu_jobsearch!=.
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Participation in job search (yesterday) `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=1
*ticks
local varx_d=0.2
local itu=1
}

if "`varx'"=="tu60_jobsearch" {
gen   vart = (tu_jobsearch>60) if tu_jobsearch!=. & tu_jobsearch>0
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Fraction searching more than 60 min (yesterday) `titlab2'"
local ylab=""
* range
local varx_m=0.3
local varx_p=0.9
*ticks
local varx_d=0.2
local itu=1
}

if "`varx'"=="tu120_jobsearch" {
gen   vart = (tu_jobsearch>120) if tu_jobsearch!=. & tu_jobsearch>0
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Fraction searching more than 120 min (yesterday) `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=0.6
*ticks
local varx_d=0.2
local itu=1
}



if "`varx'"=="tup60_jobsearch" {
gen   vart = (tu_jobsearch<=60 & tu_jobsearch>0) if tu_jobsearch!=.
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Fraction searching 1-60 min (yesterday) `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=0.4
*ticks
local varx_d=0.1
local itu=1
}

if "`varx'"=="tup120_jobsearch" {
gen   vart = (tu_jobsearch<=120 & tu_jobsearch>60) if tu_jobsearch!=.
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Fraction searching 61-120 min (yesterday) `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=0.4
*ticks
local varx_d=0.1
local itu=1
}


if "`varx'"=="tupplus120_jobsearch" {
gen   vart = (tu_jobsearch>120) if tu_jobsearch!=.
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Fraction searching more than 120 min (yesterday) `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=0.4
*ticks
local varx_d=0.1
local itu=1
}

if "`varx'"=="tum_jobsearch" {
gen   vart = tu_jobsearch if tu_jobsearch>0
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Job search (yesterday), conditional on non-zero search `titlab2'"
local ylab="Minutes per day"
* range
local varx_m=0
local varx_p=180
 *ticks
local varx_d=60
local itu=1
}


if "`varx'"=="ta_jobsearch" {
gen   vart = ta_jobsearch
gen   varwgt = curwkwgt if curwkwgt_tu!=.
local titlab = "Time spent on job search - counting all episodes as 1 hour `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=200
*ticks
local varx_d=50
local itu=1
}


if "`varx'"=="tw_jobsearch" {
gen   vart = 60*tw_jobsearch/7
gen   varwgt = curwkwgt
local titlab = "Time spent on job search (last 7 days) `titlab2'"
local ylab="Minutes per day"
* range
local varx_m=0
local varx_p=160
*ticks
local varx_d=40
local itu=0
}

if "`varx'"=="twp_jobsearch" {
gen   vart = (tw_jobsearch>0) if tw_jobsearch!=.
gen   varwgt = curwkwgt
local titlab = "Participation in job search (last 7 days) `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=1
*ticks
local varx_d=0.2
local itu=0
}

if "`varx'"=="twm_jobsearch" {
gen   vart = tw_jobsearch*60/7 if tw_jobsearch>0
gen   varwgt = curwkwgt
local titlab = "Job search (last 7 days), conditional on non-zero search `titlab2'"
local ylab="Minutes per day"
* range
local varx_m=0
local varx_p=180
*ticks
local varx_d=60
local itu=0
}

if "`varx'"=="nappl" {
gen   vart = q11a
replace vart= 0 if q9a>1 & week>1
gen   varwgt = curwkwgt
local titlab = "Number of applications (last 7 days) `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=12
*ticks
local varx_d=4
local itu=0
}



if "`varx'"=="foodtot" {
gen   vart = foodtot_imputed
gen   varwgt = curwkwgt
local titlab = "Food consumption (last 7 days) `titlab2'"
local ylab="amount in $"
* range
local varx_m=100
local varx_p=200
*ticks
local varx_d=25
local itu=0
}

if "`varx'"=="durab" {
gen   vart = durab
gen   varwgt = curwkwgt
local titlab = "Sold durable in last 7 days `titlab2'"
local ylab=""
* range
local varx_m=0
local varx_p=0.4
*ticks
local varx_d=0.1
local itu=0
}

if "`varx'"=="ind_manu" {
gen   vart = ind_manu
gen   varwgt = curwkwgt
local titlab = "Fraction in manufacturing `titlab2'"
local txtndrop = ""
local ylab=""
local ifix=0
local ires=0
local indi=`indid'
* range
local varx_m=0
local varx_p=0.15
*ticks
local varx_d=0.05
if `indi'==0 {
local varx_m=0
local varx_p=0.4
local varx_d=0.1
}
local itu=0
}

if "`varx'"=="ind_cons" {
gen   vart = ind_cons
gen   varwgt = curwkwgt
local titlab = "Fraction in construction `titlab2'"
local txtndrop = ""
local ylab=""
local ifix=0
local ires=0
local indi=`indid'
* range
local varx_m=0
local varx_p=0.15
*ticks
local varx_d=0.05
local itu=0
}


if "`varx'"=="ind_eduhealth" {
gen   vart = ind_eduhealth
gen   varwgt = curwkwgt
local titlab = "Fraction in education or health services `titlab2'"
local txtndrop = ""
local ylab=""
local ifix=0
local ires=0
local indi=`indid'
* range
local varx_m=0
local varx_p=0.15
*ticks
local varx_d=0.05
if `indi'==0 {
local varx_m=0
local varx_p=0.4
local varx_d=0.1
}
local itu=0
}

if "`varx'"=="ind_fin" {
gen   vart = ind_fin
local titlab = "Fraction in finance or insurance `titlab2'"
local txtndrop = ""
local ylab=""
gen   varwgt = curwkwgt
local ifix=0
local ires=0
local indi=`indid'
* range
local varx_m=0
local varx_p=0.15
*ticks
local varx_d=0.05
local itu=0
}


if "`varx'"=="baseearn_tc90" {
gen   vart = baseearn_tc90
local titlab = "Earnings in base year `titlab2'"
local ylab="amount in $"
gen   varwgt = curwkwgt
local ifix=0
local ires=0
local indi=`indid'
if `indi'==1 {
local txtndrop = ""
}
* range
if `iwgt'==1 {
local varx_m=28000
local varx_p=44000
local varx_d=4000
}
if `iwgt'==0 {
local varx_m=44000
local varx_p=60000
local varx_d=4000
}
if `indi'==0 {
local varx_m=24000
local varx_p=52000
local varx_d=7000
}
local itu=0
}


if "`varx'"=="educ_col" {
gen   vart = (b3>=4) if b3!=.
local titlab = "Fraction with college degree `titlab2'"
local ylab=""
gen   varwgt = curwkwgt
local ifix=0
local ires=0
local indi=`indid'
if `indi'==1 {
local txtndrop = ""
}
* range
if `iwgt'==1 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
if `iwgt'==0 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
if `indi'==0 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
local itu=0
}


if "`varx'"=="educ_sco" {
gen   vart = (b3==3) if b3!=.
local titlab = "Fraction with some college `titlab2'"
local ylab=""
gen   varwgt = curwkwgt
local ifix=0
local ires=0
local indi=`indid'
if `indi'==1 {
local txtndrop = ""
}
* range
if `iwgt'==1 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
if `iwgt'==0 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
if `indi'==0 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
local itu=0
}


if "`varx'"=="educ_hsl" {
gen   vart = (b3<=2) if b3!=.
local titlab = "Fraction with high school degree or less `titlab2'"
local ylab=""
gen   varwgt = curwkwgt
local ifix=0
local ires=0
local indi=`indid'
if `indi'==1 {
local txtndrop = ""
}
* range
if `iwgt'==1 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
if `iwgt'==0 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
if `indi'==0 {
local varx_m=0
local varx_p=0.75
local varx_d=0.25
}
local itu=0
}

if "`varx'"=="vsatisfied" {
gen   vsatisfied = (lifesat==1) if lifesat!=.
gen   vart = vsatisfied
gen   varwgt = curwkwgt
local titlab = "Very satisfied with life `titlab2'"
local ylab = ""
* range
local varx_m=0
local varx_p=0.45
*ticks
local varx_d=0.1
local itu=0
local iforce=1
}

if "`varx'"=="satisfied" {
gen   vart = satisfied
gen   varwgt = curwkwgt
local titlab = "Very satisfied or satisfied with life `titlab2'"
local ylab = ""
* range
local varx_m=0.2
local varx_p=0.85
*ticks
local varx_d=0.2
local itu=0
local iforce=1
}

if "`varx'"=="nsatisfied" {
gen   nsatisfied = (lifesat==4) if lifesat!=.
gen   vart = nsatisfied
gen   varwgt = curwkwgt
local titlab = "Not at all satisfied with life `titlab2'"
local ylab = ""
* range
local varx_m=0
local varx_p=0.45
*ticks
local varx_d=0.1
local itu=0
local iforce=1
}

if "`varx'"=="mood_1" {
gen   vart = mood_1
gen   varwgt = curwkwgt
local titlab = "% of time in a bad mood (at home) `titlab2'"
local ylab = ""
* range
local varx_m=0
local varx_p=40
*ticks
local varx_d=10
local itu=0
local iforce=1
}


if "`varx'"=="mood_2" {
gen   vart = mood_2
gen   varwgt = curwkwgt
local titlab = "% of time a little low or irritable (at home) `titlab2'"
local ylab = ""
* range
local varx_m=0
local varx_p=40
*ticks
local varx_d=10
local itu=0
local iforce=1
}


if "`varx'"=="mood_3" {
gen   vart = mood_3
gen   varwgt = curwkwgt
local titlab = "% of time in a mildly pleasant mood (at home) `titlab2'"
local ylab = ""
* range
local varx_m=20
local varx_p=60
*ticks
local varx_d=10
local itu=0
local iforce=1
}


if "`varx'"=="mood_4" {
gen   vart = mood_4
gen   varwgt = curwkwgt
local titlab = "% of time in a very good mood (at home) `titlab2'"
local ylab = ""
* range
local varx_m=10
local varx_p=60
*ticks
local varx_d=10
local itu=0
local iforce=1
}


if "`varx'"=="q5_happy" {

gen     wgt_js = tu_jobsearch/(960 - tu_notavail - tu_sleeping)
gen     emwgt = curwkwgt*(1-wgt_js)/3

gen imod_episode1 = 0 if curwkwgt_tu!=.
gen imod_episode2 = 0 if curwkwgt_tu!=.
gen imod_episode3 = 0 if curwkwgt_tu!=.
replace imod_episode1 = 1 if q5_happy_episode1!=. & q5_sad_episode1!=. & q5_stressed_episode1!=. & curwkwgt_tu!=.
replace imod_episode2 = 1 if q5_happy_episode2!=. & q5_sad_episode2!=. & q5_stressed_episode2!=. & curwkwgt_tu!=.
replace imod_episode3 = 1 if q5_happy_episode3!=. & q5_sad_episode3!=. & q5_stressed_episode3!=. & curwkwgt_tu!=.
gen idd = _n
reshape  long q5_happy_episode imod_episode, i(idd) j(episode)

gen   vart = q5_happy_episode
gen   varwgt = emwgt if imod_episode==1 & curwkwgt_tu!=.
local titlab = "Happy (during random episode) `titlab2'"
local ylab = ""
* range
local varx_m=2
local varx_p=5
*ticks
local varx_d=1
local itu=1
local iforce=1
}

if "`varx'"=="q5_sad" {

gen     wgt_js = tu_jobsearch/(960 - tu_notavail - tu_sleeping)
gen     emwgt = curwkwgt*(1-wgt_js)/3

gen imod_episode1 = 0 if curwkwgt_tu!=.
gen imod_episode2 = 0 if curwkwgt_tu!=.
gen imod_episode3 = 0 if curwkwgt_tu!=.
replace imod_episode1 = 1 if q5_happy_episode1!=. & q5_sad_episode1!=. & q5_stressed_episode1!=. & curwkwgt_tu!=.
replace imod_episode2 = 1 if q5_happy_episode2!=. & q5_sad_episode2!=. & q5_stressed_episode2!=. & curwkwgt_tu!=.
replace imod_episode3 = 1 if q5_happy_episode3!=. & q5_sad_episode3!=. & q5_stressed_episode3!=. & curwkwgt_tu!=.
gen idd = _n
reshape  long q5_sad_episode imod_episode, i(idd) j(episode)

gen   vart = q5_sad_episode
gen   varwgt = emwgt if imod_episode==1 & curwkwgt_tu!=.
local titlab = "Sad (during random episode) `titlab2'"
local ylab = ""
* range
local varx_m=0
local varx_p=3
*ticks
local varx_d=1
local itu=1
local iforce=1
}


if "`varx'"=="q5_stressed" {

gen     wgt_js = tu_jobsearch/(960 - tu_notavail - tu_sleeping)
gen     emwgt = curwkwgt*(1-wgt_js)/3

gen imod_episode1 = 0 if curwkwgt_tu!=.
gen imod_episode2 = 0 if curwkwgt_tu!=.
gen imod_episode3 = 0 if curwkwgt_tu!=.
replace imod_episode1 = 1 if q5_happy_episode1!=. & q5_sad_episode1!=. & q5_stressed_episode1!=. & curwkwgt_tu!=.
replace imod_episode2 = 1 if q5_happy_episode2!=. & q5_sad_episode2!=. & q5_stressed_episode2!=. & curwkwgt_tu!=.
replace imod_episode3 = 1 if q5_happy_episode3!=. & q5_sad_episode3!=. & q5_stressed_episode3!=. & curwkwgt_tu!=.
gen idd = _n
reshape  long q5_stressed_episode imod_episode, i(idd) j(episode)

gen   vart = q5_stressed_episode
gen   varwgt = emwgt if imod_episode==1 & curwkwgt_tu!=.
local titlab = "Stressed (during random episode) `titlab2'"
local ylab = ""
* range
local varx_m=0.5
local varx_p=3.5
*ticks
local varx_d=1
local itu=1
local iforce=1
}



if "`varx'"=="sel_happy" {

gen     wgt_js = tu_jobsearch/(960 - tu_notavail - tu_sleeping)
gen     emwgt = curwkwgt*wgt_js

gen     isel_mod = 0 if curwkwgt_tu!=. & tu_jobsearch>0
replace isel_mod = 1 if sel_happy!=. & sel_sad!=. & sel_stressed!=. & curwkwgt_tu!=.
gen   vart = sel_happy
gen   varwgt = emwgt if isel_mod==1
local titlab = "Happy (during episode of job search) `titlab2'"
local ylab = ""
* range
local varx_m=1.5
local varx_p=4.5
*ticks
local varx_d=1
local itu=1
local ndrop=30
local txtndrop="Cells with less than `ndrop' observations are dropped from the graph."
local iforce=1
}

if "`varx'"=="sel_sad" {

gen     wgt_js = tu_jobsearch/(960 - tu_notavail - tu_sleeping)
gen     emwgt = curwkwgt*wgt_js

gen     isel_mod = 0 if curwkwgt_tu!=. & tu_jobsearch>0
replace isel_mod = 1 if sel_happy!=. & sel_sad!=. & sel_stressed!=. & curwkwgt_tu!=.
gen   vart = sel_sad
gen   varwgt = emwgt if isel_mod==1
local titlab = "Sad (during episode of job search) `titlab2'"
local ylab = ""
* range
local varx_m=1
local varx_p=4
*ticks
local varx_d=1
local itu=1
local ndrop=30
local txtndrop="Cells with less than `ndrop' observations are dropped from the graph."
local iforce=1
}

if "`varx'"=="sel_stressed" {

gen     wgt_js = tu_jobsearch/(960 - tu_notavail - tu_sleeping)
gen     emwgt = curwkwgt*wgt_js

gen     isel_mod = 0 if curwkwgt_tu!=. & tu_jobsearch>0
replace isel_mod = 1 if sel_happy!=. & sel_sad!=. & sel_stressed!=. & curwkwgt_tu!=.
gen   vart = sel_stressed
gen   varwgt = emwgt if isel_mod==1
local titlab = "Stressed (during episode of job search) `titlab2'"
local ylab = ""
* range
local varx_m=1.5
local varx_p=4.5
*ticks
local varx_d=1
local itu=1
local ndrop=30
local txtndrop="Cells with less than `ndrop' observations are dropped from the graph."
local iforce=1
}


if `ituforce'==0 {
local itu=0
}



*** estimate fixed effects for each cohort ***
if `ifix'==1 {
gen vartfix=.
forvalues x=1(1)8 {

if `itu'==1 {
quietly areg vart ud_dummy_* q2_* [pw=varwgt] if coh==`x', absorb(caseid)
predict vartfix`x'
replace vartfix=vartfix`x' if coh==`x'
}
if `itu'==0 {
quietly areg vart ud_dummy_* [pw=varwgt] if coh==`x', absorb(caseid)
predict vartfix`x'
replace vartfix=vartfix`x' if coh==`x'
}

}
}

if `ifix'==0 {
gen vartfix=vart
}

gen yearclaim = year(dateclaim)
tab yearclaim, gen(yearclaim_)
drop yearclaim_4

*** estimate cohort effect ***
if `icoh'==1 {
drop r_white ethnic_nhisp
gen weekendday = (q2>5) if q2!=.
if `itu'==1 {
quietly reg vart age agesq school lprevwage_wkly lbenerate female r_* ethnic_* weekendday [pw=varwgt]
predict vartcoh1p
predict vartcoh1, res
gen xexpand=varwgt/20
expand xexpand
egen vartcoh1m = mean(vartcoh1p)
sort id week
by id week: keep if _n==1
*gen vartcoh1m = _b[_cons] + 40*_b[age] + 40*40*_b[agesq] + log(700)*_b[lprevwage_wkly] + log(420)*_b[lbenerate] + 14*_b[school]
replace vartcoh1 = vartcoh1m + vartcoh1
drop vartcoh1m vartcoh1p
}
if `itu'==0 {
quietly reg vart age agesq school lprevwage_wkly lbenerate female r_* ethnic_* [pw=varwgt] 
predict vartcoh1p
predict vartcoh1, res
gen xexpand=varwgt/20
expand xexpand
egen vartcoh1m = mean(vartcoh1p)
sort id week
by id week: keep if _n==1
*gen vartcoh1m = _b[_cons] + 40*_b[age] + 40*40*_b[agesq] + log(700)*_b[lprevwage_wkly] + log(420)*_b[lbenerate] + 14*_b[school]
replace vartcoh1 = vartcoh1m + vartcoh1
drop vartcoh1m vartcoh1p
}
}

if `icoh'==2 {
gen vartcoh1=.
drop r_white ethnic_nhisp
gen weekendday = (q2>5) if q2!=.
forvalues x=1(1)8 {
if `itu'==1 {
quietly reg vart age agesq school lprevwage_wkly lbenerate female r_* ethnic_* weekendday [pw=varwgt] 
replace vartcoh1 = _b[_cons] + 40*_b[age] + 40*40*_b[agesq] + log(700)*_b[lprevwage_wkly] + log(420)*_b[lbenerate] + 14*_b[school] if coh==`x'
}
if `itu'==0 {
quietly reg vart age agesq school lprevwage_wkly lbenerate female r_* ethnic_* [pw=varwgt]  if coh==`x'
replace vartcoh1 = _b[_cons] + 40*_b[age] + 40*40*_b[agesq] + log(700)*_b[lprevwage_wkly] + log(420)*_b[lbenerate] + 14*_b[school] if coh==`x'
}
}
}

if `icoh'==0 {
gen vartcoh1 = vart
}


*** estimate residual effect ***
if `ires'==1 {

if `itu'==1 {
* compute residual for each individual (taking out the individual average)
quietly areg vart q2_* [pw=varwgt], absorb(caseid)
predict vartres, res
}
if `itu'==0 {
quietly areg vart [pw=varwgt], absorb(caseid)
predict vartres, res
}
}

if `ires'==0 {
gen vartres=vart
}

*** take cohort average in week1 of survey ***
sort coh week
by coh week: egen vartmean_w1 = mean(vart)
sort coh week
by coh: replace vartmean_w1 = vartmean_w1[1]

if `indi'==1 {
gen xexpand=varwgt/20
expand xexpand
sort coh week
by coh: egen mvart = mean(vart) if week==1
sort id week
by id week: keep if _n==1
sort id week
by id: replace vart=mvart[1]
drop mvart
}

* take average by duration and cohort
collapse (mean) vart_l=vart vartres vartfix vartmean_w1 vartcoh1 (count) N=vart [aw=varwgt], by(ud coh)

* drop averages with less than 50 obs
drop if N<`ndrop'

* take cohort average and rescale residual to cohort average
sort coh
by coh: egen vartmean = mean(vart_l)
replace vartres = vartres + vartmean

* reshape to wide view
reshape wide vart_l vartres vartfix vartcoh1 vartmean vartmean_w1 N, i(ud) j(coh) 


*******************************
*** figures: duration plots ***
*******************************

tsset ud

* figure: raw averages
graph twoway tsline vart_l1 vart_l2 vart_l3 vart_l4 vart_l5 vart_l6 vart_l7 vart_l8 if ud <= 102, ///
legend(off) tscale(range(0(5)100)) ttitle("Unemployment duration, in weeks") ///
lpattern(solid solid solid solid solid solid solid solid) ///
lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p') ///
graphregion(color(white))
graph export `njdir'`varx'`ngraph'.png, replace hei(1200) wid(1650)
graph export `njdir'`varx'`ngraph'.eps, replace

*ytitle("`ylab'") ///
*title("`titlab'", size(medsmall) color(black)) ///
*subtitle("`subtitlab'", size(small) color(black)) ///
*note("`txtnote'`txtsvywgt'`txtndrop'" ///
*"Universe: Unemployed; no job offer yet accepted; age 20-65.", size(vsmall)) ///

* figure: fixed effects
if `ifix'==1 {
graph twoway tsline vartfix1 vartfix2 vartfix3 vartfix4 vartfix5 vartfix6 vartfix7 vartfix8 if ud <= 102, ///
legend(off) tscale(range(0(5)100)) ttitle("Unemployment duration, in weeks") ///
lpattern(solid solid solid solid solid solid solid solid) ///
lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p') ///
graphregion(color(white)) ///
note("Note: The figure removes individual fixed effects.")
graph export `njdir'`varx'fix`ngraph'.png, replace hei(1200) wid(1650)
graph export `njdir'`varx'fix`ngraph'.eps, replace
}

*ytitle("`ylab'") ///
*title("`titlab' - fixed effects", size(medsmall) color(black)) ///
*subtitle("`subtitlab'", size(small) color(black)) ///
*note("`txtnote'`txtsvywgt'`txtndrop'" ///
*"Universe: Unemployed; no job offer yet accepted; age 20-65.", size(vsmall)) ///


* figure: cohort effects
if `icoh'==1 {
graph twoway ///
(tsline vart_l1 vart_l2 vart_l3 vart_l4 vart_l5 vart_l6 vart_l7 vart_l8  if ud <= 102, ///
title("`titlab'", size(medium) color(black)) ///
subtitle("`subtitlab'", size(small) color(black)) ///
ytitle("`ylab'") ///
note("`txtnote'`txtsvywgt' The dashed line shows the residual of a regression of time spent on job search on age," ///
"age^2, years of school, log(previous wage), log(weekly benefit amount), dummies for race, ethnicity, female and weekend." ///
"The residual is rescaled to match the time spent on job search of the average worker in the sample." ///
"Universe: Unemployed; no job offer yet accepted; age 20-65.", size(vsmall)) ///
tscale(range(0(5)100)) ttitle("Unemployment duration, in weeks") ///
lpattern(solid solid solid solid solid solid solid solid) ///
lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p')) ///
(tsline vartcoh11 vartcoh12 vartcoh13 vartcoh14 vartcoh15 vartcoh16 vartcoh17 vartcoh18 if ud <= 102, ///
lpattern(dash dash dash dash dash dash dash dash) ///
lcolor(black black black black black black black black) ///
lwidth(medthin medthin medthin medthin medthin medthin medthin medthin) ///
legend(lab(9 "Removing observables") order(9) holes(1)) ///
graphregion(color(white)))
graph export `njdir'`varx'avgvscomp`ngraph'.png, replace hei(1200) wid(1650)
}

if `icoh'==2 {
graph twoway tsline vartcoh11 vartcoh12 vartcoh13 vartcoh14 vartcoh15 vartcoh16 vartcoh17 vartcoh18 if ud <= 102, ///
title("`titlab' - cohort effects", size(medium) color(black)) ///
subtitle("", size(small) color(black)) ///
ytitle("`ylab'") ///
note("`txtnote'`txtsvywgt' The graph shows the predicted value of a regression of time spent on job search on age," ///
"age^2, years of school, log(previous wage), log(weekly benefit amount), dummies for race, ethnicity, female and weekend." ///
"The regression is run for each cohort separately, and the predicted value is taken for a male, white, non-hispanic worker of" ///
"age 40 with 14 years of school, weekly earnings of $700 and a weekly benefit amount of $420." ///
"Universe: Unemployed; no job offer yet accepted; age 20-65.", size(vsmall)) ///
legend(off) tscale(range(0(5)100)) ttitle("Unemployment duration, in weeks") ///
lpattern(solid solid solid solid solid solid solid solid) ///
lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p') ///
graphregion(color(white))
graph export `njdir'`varx'coheffect`ngraph'.png, replace hei(1200) wid(1650)
}

* figure: average residuals
if `ires'==1 {
graph twoway tsline vartres1 vartres2 vartres3 vartres4 vartres5 vartres6 vartres7 vartres8 if ud <= 102, ///
title("`titlab' - residuals", size(medium) color(black)) ///
subtitle("`subtitlab'", size(small) color(black)) ///
ytitle("`ylab'") ///
note("`txtnote'`txtsvywgt'`txtndrop'" ///
"Universe: Unemployed; no job offer yet accepted; age 20-65.", size(vsmall)) ///
legend(off) tscale(range(0(5)100)) ttitle("Unemployment duration, in weeks") ///
lpattern(solid solid solid solid solid solid solid solid) ///
lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p') ///
graphregion(color(white))
graph export `njdir'`varx'res`ngraph'.png, replace hei(1200) wid(1650)
}

* figure: comparing averages and fixed effects
if `ifix'==1 {
graph twoway ///
(tsline vart_l1 vart_l2 vart_l3 vart_l4 vart_l5 vart_l6 vart_l7 vart_l8  if ud <= 102, ///
title("`titlab'", size(medsmall) color(black)) ///
subtitle("`subtitlab'", size(small) color(black)) ///
ytitle("`ylab'") ///
note("`txtnote'`txtsvywgt'`txtndrop'" ///
"Universe: Unemployed; no job offer yet accepted; age 20-65.", size(vsmall)) ///
tscale(range(0(5)100)) ttitle("Unemployment duration, in weeks") ///
lpattern(solid solid solid solid solid solid solid solid) ///
lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p')) ///
(tsline vartfix1 vartfix2 vartfix3 vartfix4 vartfix5 vartfix6 vartfix7 vartfix8 if ud <= 102, ///
lpattern(dash dash dash dash dash dash dash dash) ///
lcolor(black black black black black black black black) ///
lwidth(medthin medthin medthin medthin medthin medthin medthin medthin) ///
legend(lab(9 "Fixed effects estimates") order(9) holes(1)) ///
graphregion(color(white)))
graph export `njdir'`varx'avgvsfix`ngraph'.png, replace hei(1200) wid(1650)
}

* figure: comparing average residuals and fixed effects
if `ires'==1 {
graph twoway ///
(tsline vartres1 vartres2 vartres3 vartres4 vartres5 vartres6 vartres7 vartres8 if ud <= 102, ///
title("`titlab'", size(medium) color(black)) ///
subtitle("`subtitlab'", size(small) color(black)) ///
ytitle("`ylab'") ///
note("`txtnote'`txtsvywgt'`txtndrop'" ///
"Universe: Unemployed; no job offer yet accepted; age 20-65.", size(vsmall)) ///
tscale(range(0(5)100)) ttitle("Unemployment duration, in weeks") ///
lpattern(solid solid solid solid solid solid solid solid) ///
lwidth(medthick medthick medthick medthick medthick medthick medthick medthick) ///
yscale(range(`varx_m'(`varx_d')`varx_p')) ylabel(`varx_m'(`varx_d')`varx_p')) ///
(tsline vartfix1 vartfix2 vartfix3 vartfix4 vartfix5 vartfix6 vartfix7 vartfix8 if ud <= 102, ///
lpattern(dash dash dash dash dash dash dash dash) ///
lcolor(black black black black black black black black) ///
lwidth(medthin medthin medthin medthin medthin medthin medthin medthin) ///
legend(lab(9 "Fixed effects estimates") order(9) holes(1)) ///
graphregion(color(white)))
graph export `njdir'`varx'resvsfix`ngraph'.png, replace hei(1200) wid(1650)
}

}






